/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.dto.SarfaslDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class SarfaslDao {
    private DbConnection dbConnection;
    private SqlRowSet rs;

    @Autowired
    public SarfaslDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public String getNameByCode(String sarfaslCode, LoginDto login) {
        String sarfaslName = "";
        this.rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT SARFASL_NAME FROM SARFASL WHERE SARFASL_CODE = '" + sarfaslCode + "'");
        while (this.rs.next()) {
            sarfaslName = this.rs.getString("SARFASL_NAME");
        }
        return sarfaslName;
    }

    public Pair<String, String> getCustomerCodeNamePairByCustomerCode(String cCode, LoginDto login) {
        Pair codeName = new Pair();
        String sqlStr = "SELECT SARFASL_NAME, SARFASL_CODE FROM SARFASL WHERE COMMON = '" + cCode + "'";
        this.rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        while (this.rs.next()) {
            codeName.setLeft((Object)this.rs.getString("SARFASL_CODE"));
            codeName.setRight((Object)this.rs.getString("SARFASL_NAME"));
        }
        return codeName;
    }

    public int getCostSarfaslCountBySarfaslCode(String sarfaslCode, int colCode, LoginDto login) {
        String sqlStr = " SELECT COUNT(*) cnt FROM SARFASL WHERE SARFASL_CODE='" + sarfaslCode + "' AND TYPE IN (SELECT DISTINCT [TYPE] FROM SARFASL WHERE COL_CODE = " + colCode + ") AND SPARENT = 0 ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        rs.next();
        return rs.getInt("cnt");
    }

    public int getSarfaslCountBySarfaslCodeAndType(String sarfaslCode, int type, LoginDto login) {
        String sqlStr = " SELECT COUNT(*) cnt FROM SARFASL WHERE SARFASL_CODE='" + sarfaslCode + "' AND [TYPE]= " + type + " AND SPARENT = 0 ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getInt("cnt");
        }
        return 0;
    }

    public void insert(SarfaslDto dto, LoginDto login) {
        String sql = " INSERT INTO [dbo].[SARFASL] ([Col_Code], [Moien_Code],\n[Tafzili_Code], [Sarfasl_Code], [Sarfasl_Name], [Mandeh], [Group], [Mahiat], [Can_Delete],\n[Common], [Delete], [MHaz_Code], [AutoUse], [Parent], [Type], [SParent], [ArzId], [Money_Price],\n[Selected]\n) VALUES (";
        this.dbConnection.getJdbcTemplate(login).update(sql + ConvertStr.getValuesQuestionMarksBasedOnInsertColNum((String)sql) + ")", new Object[]{dto.getColcode(), dto.getMoiencode(), dto.getTafzilicode(), dto.getSarfaslcode(), dto.getSarfaslname(), dto.getMandeh(), dto.getGroup(), dto.getMahiat(), ConvertStr.getBoolToInt((Boolean)dto.getCandelete()), dto.getCommon(), ConvertStr.getBoolToInt((Boolean)dto.getDelete()), dto.getMhazcode(), ConvertStr.getBoolToInt((Boolean)dto.getAutouse()), dto.getParent(), dto.getType(), dto.getSparent(), dto.getArzid(), dto.getMoneyprice(), ConvertStr.getBoolToInt((Boolean)dto.getSelected())});
    }

    public Integer getParentId(String parentSarfasl, LoginDto login) {
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT [ID] FROM SARFASL WHERE SARFASL_CODE = '" + parentSarfasl + "'");
        if (rs.next()) {
            return rs.getInt("ID");
        }
        return null;
    }

    public void updateParentAfterInsert(Integer parentId, LoginDto login) {
        this.dbConnection.getJdbcTemplate(login).update(" UPDATE SARFASL SET SPARENT = 1 WHERE [ID] = ?", new Object[]{parentId});
    }

    public void updateNameOfSarfasl(String sarfaslCode, String name, LoginDto login) {
        this.dbConnection.getJdbcTemplate(login).update(" UPDATE SARFASL SET SARFASL_NAME = ? WHERE SARFASL_CODE = ?", new Object[]{name, sarfaslCode});
    }
}

